/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.plugins.diskinfo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import jgamebase.Const;
import jgamebase.plugins.DiskInfo;

public class CRT
implements DiskInfo {
    private static final String[] supportedExtensions = new String[]{"crt"};
    private static final String IDENTIFIER = "C64 CARTRIDGE   ";
    private static final int OFFSET_START = 0;
    private static final int OFFSET_IDENTIFIER = 0;
    private static final int OFFSET_IDENTIFIEREND = 16;
    private static final int OFFSET_TYPE = 22;
    private static final int OFFSET_EXROMLINE = 24;
    private static final int OFFSET_GAMELINE = 25;
    private static final int OFFSET_NAME = 32;
    private static final int OFFSET_END = 64;
    private static final String[] TYPES = new String[]{"Normal cartridge", "Action Replay", "KCS Power Cartridge", "Final Cartridge III", "Simons Basic", "Ocean type 1", "Expert Cartridge", "Fun Play, Power Play", "Super Games", "Atomic Power", "Epyx Fastload", "Westermann Learning", "Rex Utility", "Final Cartridge I", "Magic Formel", "C64 Game System, System 3", "WarpSpeed", "Dinamic", "Zaxxon, Super Zaxxon (SEGA)", "Magic Desk, Domark, HES Australia"};
    private String type;
    private String exrromLine;
    private String gameLine;
    private String name;
    private String filesize;
    byte[] buffer;

    public CRT() {
        Const.log.info((Object)"Loaded plugin: disk info 'CRT'.");
    }

    @Override
    public void load(String filename) throws IOException {
        File file = new File(filename);
        this.buffer = new byte[64];
        if (!file.exists()) {
            throw new FileNotFoundException(filename);
        }
        FileInputStream in = new FileInputStream(file);
        int read = in.read(this.buffer, 0, 64);
        in.close();
        String identifier = this.bufferToString(0, 16);
        if (!identifier.equals(IDENTIFIER) || read < 64) {
            throw new FileNotFoundException(filename);
        }
        this.type = TYPES[this.buffer[22]];
        this.exrromLine = this.buffer[24] == 0 ? "inactive" : "active";
        this.gameLine = this.buffer[25] == 0 ? "inactive" : "active";
        this.name = this.bufferToString(32, 64).trim();
        this.filesize = String.valueOf(new File(filename).length() / 1024L) + "KB";
    }

    private String bufferToString(int start, int end) {
        StringBuilder s = new StringBuilder();
        int i = start;
        while (i < end) {
            s.append((char)this.buffer[i]);
            ++i;
        }
        return s.toString();
    }

    @Override
    public String[] getSupportedExtensions() {
        return supportedExtensions;
    }

    @Override
    public boolean supportsExtension(String extensionToFind) {
        extensionToFind = extensionToFind.toLowerCase();
        String[] stringArray = supportedExtensions;
        int n = supportedExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String supportedExtension = stringArray[n2];
            String extension = supportedExtension.toLowerCase();
            if (extension.equals(extensionToFind)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public String[] getDirectory() {
        String[] files = new String[]{"\"" + this.name + "\""};
        return files;
    }

    @Override
    public String getFilenameAt(int pos) {
        if (pos == 0) {
            return this.name;
        }
        return "";
    }

    @Override
    public String getNativeFilenameAt(int pos) {
        return this.getFilenameAt(pos);
    }

    @Override
    public String getHeader() {
        return String.valueOf(this.filesize) + " \"" + this.type + "\"";
    }

    @Override
    public String getFooter() {
        return "EXROM line: " + this.exrromLine + "   " + "GAME line: " + this.gameLine;
    }

    @Override
    public boolean isBootable() {
        return true;
    }
}

